<?php
// ++=========================================================================++
// || vBadvanced Gallery v1.0 RC2
// ||              
// ||             .
// ||       (  )
// || tranlated by: arabsdesign.com
// || www.arabsdesign.com
// ++ ========================================================================++

error_reporting(E_ALL & ~E_NOTICE);
define('NO_REGISTER_GLOBALS', 1);

$specialtemplates = array(
	'adv_gallery_opt',
	'gallery_c_cache',
);

$phrasegroups = array(
	'adv_gallery',
	'adv_gallery_cp'
);

require_once('./global.php');
require_once('./includes/functions_gallery.php');
require_once('./includes/adminfunctions_gallery.php');

$vba_options = unserialize($datastore['adv_gallery_opt']);
$categorycache = unserialize($datastore['gallery_c_cache']);

unset($datastore['adv_gallery_opt'], $datastore['gallery_c_cache']);

print_cp_header($vbphrase['vba_gallery_admin']);

if (!$_BITFIELD['usergroup']['gallerypermissions'])
{
	print_form_header('', '');
	print_table_header('Error!');
	print_description_row($vbphrase['adv_gallery_warning_file_changes']);
	print_table_footer();
	exit;
}

if (empty($_REQUEST['do']))
{
  $_REQUEST['do'] = 'dirmanager';
}

globalize($_REQUEST, array('catid' => INT, 'imageid' => INT));

// ######################### Custom Field Types ###############################
$customfieldtypes = array(
	'text' => $vbphrase['text_input_single_line'],
	'textarea' => $vbphrase['textarea_multiple_line'],
	'select' => $vbphrase['select_preset_options'],
	'radio' => $vbphrase['radio_options_must_choose'],
	'checkbox' => $vbphrase['checkbox_multiple_options']
);

// ########################### Modify Settings ################################
if ($_REQUEST['do'] == 'modifysettings')
{
	$debug = '';

	$getphrases = $DB_site->query("SELECT varname, text FROM " . TABLE_PREFIX . "phrase WHERE phrasetypeid = '5000'	ORDER BY languageid ASC");
	while($phrases = $DB_site->fetch_array($getphrases))
	{
		$settingphrase["$phrases[varname]"] = stripslashes($phrases['text']);
	}

	require_once('./includes/adminfunctions_options.php');

	$settings = $DB_site->query("
			SELECT adv_setting.*
			FROM " . TABLE_PREFIX . "adv_setting AS adv_setting
			LEFT JOIN " . TABLE_PREFIX . "adv_settinggroup AS adv_settinggroup USING (grouptitle)
			WHERE adv_settinggroup.grouptitle LIKE 'adv_gallery_%'
			ORDER BY adv_settinggroup.displayorder, adv_setting.displayorder
	");

	while ($setting = $DB_site->fetch_array($settings))
	{
		if ($setting['varname'] == 'gallery_version')
		{
			continue;
		}
		$settingscache["$setting[grouptitle]"]["$setting[varname]"] = $setting;
		$grouptitlecache["$setting[grouptitle]"] = $setting['grouptitle'];
	}

	$DB_site->free_result($settings);
	unset($setting);
	print_form_header('vba_gallery_admin', 'saveopts');

	foreach ($grouptitlecache AS $grouptitle)
	{
		print_setting_group($grouptitle);
		print_table_break();
	}
	print_submit_row();
}

// ############################ Save Settings #################################
if ($_POST['do'] == 'saveopts')
{
	globalize($_POST, array('setting'));

  foreach ($setting AS $varname => $value)
  {
		if ($varname == 'gallery_imagebitdisplay')
		{
			$value = implode(',', $value);
		}
		$DB_site->query("UPDATE " . TABLE_PREFIX . "adv_setting SET value = '" . addslashes($value) . "' WHERE varname = '$varname'");
	}

	$settings = $DB_site->query("SELECT varname, value FROM " . TABLE_PREFIX . "adv_setting WHERE varname LIKE 'gallery%'");
	while ($setting = $DB_site->fetch_array($settings))
	{
		$adv_options["$setting[varname]"] = $setting['value'];
	}
	$DB_site->free_result($settings);
	unset($setting);

	build_datastore('adv_gallery_opt', serialize($adv_options));
	print_cp_redirect("vba_gallery_admin.php?$session[sessionurl]&do=modifysettings", 0);
}

// ##################### Edit Permissions For Usergroup #######################
if ($_REQUEST['do'] == 'permissions')
{
	globalize($_REQUEST, array('u' => INT));

	$usergroups = $DB_site->query("SELECT usergroupid, title FROM " . TABLE_PREFIX . "usergroup ORDER BY usergroupid");
	while ($usergroup = $DB_site->fetch_array($usergroups))
	{
		$grouparray["$usergroup[usergroupid]"] = $usergroup['title'];
	}

	if ($u)
	{
		$usergroup = $DB_site->query_first("SELECT * FROM " . TABLE_PREFIX . "usergroup WHERE usergroupid = '$u'");
	}
	print_form_header('vba_gallery_admin', 'permissions', false, true, 'cpform', '90%', '', true, 'get');
	print_table_header(iif($usergroup['usergroupid'], $usergroup['title'], $vbphrase['modify_permissions']));

	print_description_row('' . $vbphrase['usergroup'] . ': <select name="u" class="bginput" onchange="submit();">' . construct_select_options($grouparray, $u) . '</select> <input class="button" type="submit" value="' . $vbphrase['go'] . '" />', 0, 1, '', 'center');
	print_table_footer();

	if ($u)
	{
		print_form_header('vba_gallery_admin', 'updateperms');

		$perms = convert_bits_to_array($usergroup['gallerypermissions'], $_BITFIELD['usergroup']['gallerypermissions']);

		print_label_row('<b>' . $usergroup['title'] . '</b>', '<input id="checkall2" name="checkall" onclick="js_check_all_option(this.form, 1);" type="button" value="' . $vbphrase['all_yes'] . '" /> <input id="checkall2" name="checkall" onclick="js_check_all_option(this.form, 0);" type="button" value="' . $vbphrase['all_no'] . '" />', 'tcat');

		construct_hidden_code('usergroupid', $usergroup['usergroupid']);
		construct_hidden_code('usergrouptitle', $usergroup['title']);

		print_permission_rows(false);

		print_submit_row($vbphrase['save']);
	}
}

// ########################### Do Update Permissions ##########################
if ($_POST['do'] == 'updateperms')
{

	globalize($_POST, array('usergroup', 'usergroupid' => INT, 'usergrouptitle' => STR));

	require_once('./includes/functions_misc.php');
	$galleryperms = convert_array_to_bits($usergroup, $_BITFIELD['usergroup']['gallerypermissions'], 1);

	$DB_site->query("UPDATE " . TABLE_PREFIX . "usergroup SET gallerypermissions = '$galleryperms', gallery_maxdiskspace = '$usergroup[gallery_maxdiskspace]', gallery_maxcats = '$usergroup[gallery_maxcats]' WHERE usergroupid = '$usergroupid'");

	require_once('./includes/functions_databuild.php');
	build_forum_permissions();

	define('CP_REDIRECT', "vba_gallery_admin.php?$session[sessionurl]do=permissions");
	print_stop_message('saved_usergroup_x_successfully', $usergrouptitle);

}

// ##################### Edit Permissions For Usergroup #######################
if ($_REQUEST['do'] == 'categorypermissions')
{
	$catinfo = array();

	$getcats = $DB_site->query("SELECT catid, title, parent, hasimages, displayorder FROM " . TABLE_PREFIX . "adv_gallery_categories ORDER BY displayorder ASC, hasimages");
	while ($categories = $DB_site->fetch_array($getcats))
	{
		$catinfo[] = $categories;
	}

	$DB_site->free_result($getcats);
	unset($categories);

	$usergroupperms = $DB_site->query("SELECT * FROM " . TABLE_PREFIX . "adv_gallery_permissions");
	while ($uperms = $DB_site->fetch_array($usergroupperms))
	{
		$usergroup['title'] = $usergroupcache["$u"]['title'];
		$hasperms["$uperms[usergroupid]"]["$uperms[catid]"] = true;
	}

	print_form_header('', '');
	print_table_header($vbphrase['category_permissions']);
	print_description_row('
		<div class="darkbg" style="border:2px inset">
			<ul class="darkbg">
				<li><b>' . $vbphrase['color_key'] . '</b></li>
				<li class="col-g">' . $vbphrase['standard_using_default_usergroup_permissions'] . '</li>
				<li class="col-c">' . $vbphrase['customized_using_custom_permissions_for_this_usergroup'] . '</li>
				<li class="col-i">' . $vbphrase['inherited_using_custom_permissions_from_parent_category'] . '</li>
			</ul>
		</div>
	');
	print_table_break();

	print_description_row('<div class="darkbg" style="border: 2px inset">' .

	print_category_perm_rows($catinfo, 0)

	);
	print_table_footer();

}

// ######################## Edit Permissions for Category #####################
if ($_REQUEST['do'] == 'editcategoryperms')
{
	globalize($_REQUEST, array('u' => INT, 'c' => INT));

	?>
	<script type="text/javascript">
	<!--
	function js_set_custom()
	{
		if (document.cpform.useusergroup[1].checked == false)
		{
			if (confirm("<?php echo $vbphrase['for_setting_effect_permissions_for_usergroup_enabled']; ?>"))
			{
				document.cpform.useusergroup[1].checked = true;
				return true;
			}
			else
			{
				return false;
			}
		}
		else
		{
			return true;
		}
	}
	// -->
	</script>
	<?php

	if ($usergroup = $DB_site->query_first("SELECT * FROM " . TABLE_PREFIX . "adv_gallery_permissions WHERE usergroupid = '$u' AND catid = '$c'"))
	{
		$perms = convert_bits_to_array($usergroup['permissions'], $_BITFIELD['usergroup']['gallerypermissions']);
	}
	else
	{
		$perms = fetch_category_perms($c, explode(',', $u));
	}

	$usergroup['title'] = $usergroupcache["$u"]['title'];
	$category['title'] = $categorycache["$c"]['title'];

	print_form_header('vba_gallery_admin', 'doeditcatperms');
	construct_hidden_code('usergroup[usergroupid]', $u);
	construct_hidden_code('usergroup[catid]', $c);
	print_table_header(construct_phrase($vbphrase['edit_category_permissions_for_usergroup_x_in_category_y'], $usergroup['title'], $category['title']));

	print_description_row('
		<label for="use_default"><input ' . iif(!isset($usergroup['permissions']), ' checked="checked"') . ' id="use_default" name="useusergroup" onclick="this.form.reset(); this.checked=true;" type="radio" value="0" />' . $vbphrase['use_default_permissions_note_delete_previous_permissions_set'] . '</label>
		<br />
		<label for="use_custom"><input id="use_custom" ' . iif(isset($usergroup['permissions']), ' checked="checked"') . ' name="useusergroup" type="radio" value="1" />' . $vbphrase['use_custom_permissions'] . '</label>
	', 0, 2, 'tfoot', '' , 'mode');
	print_table_break();

	print_table_break();

	print_label_row('<b>' . $usergroup['title'] . '</b>',
		'<input id="checkall" name="checkall" onclick="js_check_all_option(this.form, 1); js_set_custom();" type="button" value="' . $vbphrase['all_yes'] . '" />
		<input id="checkall" name="checkall" onclick="js_check_all_option(this.form, 0); js_set_custom();" type="button" value="' . $vbphrase['all_no'] . '" />', 'tcat');

	construct_hidden_code('usergroupid', $usergroup['usergroupid']);
	construct_hidden_code('usergrouptitle', $usergroup['title']);

	print_permission_rows(true);

	print_submit_row($vbphrase['save']);
}

// ###################### Do Add/Edit Category Permissions ####################
if ($_POST['do'] == 'doeditcatperms')
{
	globalize($_POST, array('usergroup', 'useusergroup'));

	require_once('./includes/functions_misc.php');
	$perms = convert_array_to_bits($usergroup, $_BITFIELD['usergroup']['gallerypermissions'], 1);

	$checkexists = $DB_site->query_first("SELECT * FROM " . TABLE_PREFIX . "adv_gallery_permissions WHERE catid = '$usergroup[catid]' AND usergroupid = '$usergroup[usergroupid]'");

	if (!$useusergroup AND !empty($checkexists))
	{
		$DB_site->query("DELETE FROM " . TABLE_PREFIX . "adv_gallery_permissions WHERE usergroupid = '$usergroup[usergroupid]' AND catid = '$usergroup[catid]'");
	}

	if ($useusergroup)
	{
		if (empty($checkexists))
		{
			$DB_site->query("INSERT INTO " . TABLE_PREFIX . "adv_gallery_permissions (catid, usergroupid, permissions) VALUES ('$usergroup[catid]', '$usergroup[usergroupid]', '$perms')");
		}
		else
		{
			$DB_site->query("UPDATE " . TABLE_PREFIX . "adv_gallery_permissions SET permissions = '$perms' WHERE usergroupid = '$usergroup[usergroupid]' AND catid = '$usergroup[catid]'");
		}
	}
	update_category_cache();
	print_cp_redirect("vba_gallery_admin.php?$session[sessionurl]do=categorypermissions", 0);
}

// ######################### Reset Category Permissions ######################
if ($_REQUEST['do'] == 'resetperms')
{
	$DB_site->query("DELETE FROM " . TABLE_PREFIX . "adv_gallery_permissions WHERE catid = '$_REQUEST[catid]'");
	update_category_cache();

	print_cp_redirect("vba_gallery_admin.php?$session[sessionurl]do=categorypermissions", 0);
}

// ############################ Deny All Permission ###########################
if ($_REQUEST['do'] == 'denyperms')
{
	$usergroups = $DB_site->query("SELECT usergroupid FROM " . TABLE_PREFIX . "usergroup");
	while ($usergroup = $DB_site->fetch_array($usergroups))
	{
		$DB_site->query("INSERT INTO " . TABLE_PREFIX . "adv_gallery_permissions (catid, usergroupid, permissions) VALUES ('$_REQUEST[catid]', '$usergroup[usergroupid]', 0)");
	}

	update_category_cache();

	print_cp_redirect("vba_gallery_admin.php?$session[sessionurl]do=categorypermissions", 0);
}

// ############################# Manage Categories ###########################
if ($_REQUEST['do'] == 'dirmanager')
{
	?>
	<script type="text/javascript">
	function js_dir_jump(catid)
	{
		action = eval("document.cpform.c" + catid + ".options[document.cpform.c" + catid + ".selectedIndex].value");
		switch (action)
		{
			case 'edit':
				page = 'vba_gallery_admin.php?do=editcat&catid=';
				break;
			case 'remove':
				page = 'vba_gallery_admin.php?do=deletecat&catid=';
				break;
			case 'addsub':
				page = 'vba_gallery_admin.php?do=addcat&parentid=';
				break;
			case 'view':
				page = '<? echo $vba_options['gallery_url'] ?>/browseimages.php?c=';
				break;
			case 'empty':
				page = 'vba_gallery_admin.php?do=empty&catid=';
				break;
			case 'massedit':
				page = 'vba_gallery_admin.php?do=massedit&catid=';
				break;
		}
		document.cpform.reset();

		window.location = page + catid + "&s=<?php echo $session['sessionhash']; ?>";
	}

	function js_mod_jump(catid)
	{
		modid = eval("document.cpform.m" + catid + ".options[document.cpform.m" + catid + ".selectedIndex].value");
		document.cpform.reset();
		switch (modid)
		{
			case 'addmod':
				window.location = "vba_gallery_admin.php?s=<?php echo $session['sessionhash']; ?>&do=addmoderator&catid=" + catid;
				break;
			default:

				window.location = "vba_gallery_admin.php?s=<?php echo $session['sessionhash']; ?>&do=editmoderator&modid=" + modid + "&catid=" + catid; break;
		}
	}

	</script>

	<?php

	$diroptions = array(
		'edit' => $vbphrase['edit_category'],
		'view' => $vbphrase['view_images'],
		'empty' => $vbphrase['empty_category'],
		'remove' => $vbphrase['remove_category'],
		'addsub' => $vbphrase['add_sub_category'],
		'massedit' => $vbphrase['mass_edit_delete']
	);

	print_form_header('vba_gallery_admin', 'doorder');
	print_table_header($vbphrase['modify_links_categories'], 4);
	print_cells_row(array($vbphrase['title'], $vbphrase['controls'], $vbphrase['display_order'], $vbphrase['moderator']), 1);

	$getcats = $DB_site->query("SELECT catid, title, parent, hasimages, displayorder FROM " . TABLE_PREFIX . "adv_gallery_categories ORDER BY displayorder ASC, hasimages");
	while ($categories = $DB_site->fetch_array($getcats))
	{
		$catinfo[] = $categories;
	}

	$DB_site->free_result($getcats);
	unset($categories);

	// Get Moderator Info
	$mods = $DB_site->query('SELECT * FROM ' . TABLE_PREFIX . 'adv_gallery_moderator');
	while ($gmods = $DB_site->fetch_array($mods))
	{
		$gallerymods[] = $gmods;
	}

	$DB_site->free_result($mods);
	unset($gmods);

	if ($gallerymods)
	{
		foreach ($gallerymods AS $moderator)
		{
			$gallery_modcache["$moderator[catid]"]["$moderator[userid]"] = $moderator;
		}
	}

	// Construct The Directories
	if ($catinfo = construct_categories($catinfo, 0, -1));
	{
		if (!empty($catinfo))
		{
			foreach ($catinfo as $cats)
			{
				// Figure out who moderates which category
				if ($gallery_modcache["$cats[catid]"])
				{
					$modcounts = 0;
					foreach($gallery_modcache["$cats[catid]"] AS $moderator)
					{
						$modcounts++;
						$modopts["$cats[catid]"] .= '<option value="' . $moderator['userid'] . '"> &nbsp; ' . $moderator['username'] . '</option>';
						$modcount["$cats[catid]"] = $modcounts;
					}
				}

				$cell = array();

				$cell[] = '<b>' . str_repeat('- - ', ($cats['level'] - 1)) . ' <a href="vba_gallery_admin.php?' . $session['sessionhash'] . 'do=editcat&amp;catid=' . $cats['catid'] . '">' . stripslashes($cats['title']) . '</a></b>';

				$cell[] = '<select name="c' . $cats['catid'] . '" onchange="js_dir_jump(' . $cats['catid'] . ');" class="bginput">' . construct_select_options($diroptions) . '</select><input class="button" type="button" value="' . $vbphrase['go'] . '" onclick="js_dir_jump(' . $cats['catid'] . ');" />';

				$cell[] = '<input type="text" class="bginput" name="order[' . $cats['catid'] . ']" size="3" title="' . $vbphrase['edit_display_order'] . '" value="' . $cats['displayorder'] . '" />';

				$cell[] = '<select class="bginput" name="m' . $cats['catid'] . '" onchange="js_mod_jump(' . $cats['catid']  . ');"><option value="0">' . $vbphrase['moderators'] . ' (' . number_format($modcount["$cats[catid]"]) . ')</option>' . $modopts["$cats[catid]"] . '<option value="addmod">' . $vbphrase['add_moderator'] . '</option></select><input class="button" onclick="js_mod_jump(' . $cats['catid'] . ');" type="button" value="' . $vbphrase['go'] . '" />';

				print_cells_row($cell);
			}
		}
		unset($catinfo, $moderator, $gallery_modcache);
	}
	print_submit_row($vbphrase['save_display_order'], $vbphrase['reset'], 4);
}

// ############################# Re-Order Categories ##########################
if ($_POST['do'] == 'doorder')
{

  foreach ($_POST['order'] AS $catid => $disorder)
  {
		$DB_site->query("UPDATE " . TABLE_PREFIX . "adv_gallery_categories SET displayorder = '$disorder' WHERE catid = '$catid'");
  }
	update_category_cache();
	define('CP_REDIRECT', 'vba_gallery_admin.php' . $session['sessionurl']);
	print_stop_message('saved_display_order_successfully');
}

// ############################## Add/Edit Category ##########################
if (in_array($_REQUEST['do'], array('addcat', 'editcat')))
{

	globalize($_REQUEST, array('catid' => INT, 'parentid' => INT));

	print_form_header('vba_gallery_admin', iif($_REQUEST['do'] == 'addcat', 'doaddcat', 'doeditcat'));

	if ($_REQUEST['do'] == 'editcat')
	{
		$cat = $DB_site->query_first("
				SELECT categories.*, user.username
				FROM " . TABLE_PREFIX . "adv_gallery_categories AS categories
				LEFT JOIN " . TABLE_PREFIX . "user AS user ON (categories.catuserid = user.userid)
				WHERE catid = '$catid'
		");
		construct_hidden_code('catinfo[catid]', $cat['catid']);
		construct_hidden_code('catinfo[oldparentid]', $cat['parent']);
		construct_hidden_code('catinfo[oldpassword]', $cat['password']);

		$options = convert_bits_to_array($cat['options'], $categoryopts);
		$useropts = convert_bits_to_array($cat['useroptions'], $catuseropts);
	}
	else
	{
		$cat['hasimages'] = 1;
		$cat['parent'] = $parentid;
		$cat['active'] = 1;
		$options['open_for_images'] = 1;
		$options['open_for_posts'] = 1;
		$options['allow_desc_html'] = 0;
		$options['allow_desc_bbcode'] = 1;
		$options['allow_desc_bbimgcode'] = 1;
		$options['allow_desc_smilies'] = 1;
		$options['allow_custom_html'] = 0;
		$options['allow_custom_bbcode'] = 1;
		$options['allow_custom_bbimgcode'] = 1;
		$options['allow_custom_smilies'] = 1;
		$options['allow_post_html'] = 0;
		$options['allow_post_bbcode'] = 1;
		$options['allow_post_bbimgcode'] = 1;
		$options['allow_post_smilies'] = 1;
		$options['allow_post_icons'] = 1;
		$options['allow_replies'] = 1;
		$options['allow_ratings'] = 1;
	}

	print_table_header(iif($_REQUEST['do'] == 'addcat', $vbphrase['add_category'], construct_phrase($vbphrase['x_y_id_z'], $vbphrase['edit_category'], $cat['title'], $cat['catid'])));
	print_input_row($vbphrase['title'] . ':', 'catinfo[title]', stripslashes($cat['title']));
	print_textarea_row($vbphrase['description'] . ':', 'catinfo[description]', stripslashes($cat['description']));
	print_input_row($vbphrase['display_order'] . ':' . iif($_REQUEST['do'] == 'addcat', $vbphrase['set_to_neg_1_first']), 'catinfo[displayorder]', $cat['displayorder']);
	print_category_select('catinfo[parentid]', $cat['parent'], $vbphrase['none'], $vbphrase['category_parent']);
	print_input_row($vbphrase['image'] . ':', 'catinfo[catimage]', stripslashes($cat['catimage']));

	print_table_header($vbphrase['category_options']);
	print_input_row($vbphrase['email_addresses_notify_when_new_upload'], 'catinfo[newimageemail]', $catinfo['newimageemail']);
	print_input_row($vbphrase['email_addresses_notify_when_new_post'], 'catinfo[newpostemail]', $catinfo['newpostemail']);
	print_yes_no_row($vbphrase['act_as_category'], 'catinfo[hasimages]', $cat['hasimages']);
	print_yes_no_row($vbphrase['category_is_active_will_not_appear_ramians_accessible'], 'catinfo[active]', $cat['active']);
	print_yes_no_row($vbphrase['allow_users_create_subcats'], 'catinfo[allowusercats]', $cat['allowusercats']);
	print_yes_no_row($vbphrase['category_is_open_for_images'], 'options[open_for_images]', $options['open_for_images']);
	print_yes_no_row($vbphrase['category_is_open_for_posts'], 'options[open_for_posts]', $options['open_for_posts']);
	print_yes_no_row($vbphrase['allow_replies'], 'options[allow_replies]', $options['allow_replies']);
	print_yes_no_row($vbphrase['allow_ratings'], 'options[allow_ratings]', $options['allow_ratings']);

	print_table_header($vbphrase['user_options']);
	print_input_row($vbphrase['category_owner_enter_username'], 'catinfo[catusername]', $cat['username']);
	print_yes_no_row($vbphrase['allow_other_users_view'], 'useropts[allow_view]', $useropts['allow_view']);
	print_yes_no_row($vbphrase['allow_other_users_upload'], 'useropts[allow_upload]', $useropts['allow_upload']);
	print_yes_no_row($vbphrase['allow_other_users_reply'], 'useropts[allow_reply]', $useropts['allow_reply']);
	print_yes_no_row($vbphrase['allow_other_users_rate'], 'useropts[allow_rating]', $useropts['allow_rating']);

	print_table_header($vbphrase['access_options']);
	print_input_row($vbphrase['category_password_acts_in_addition_other_permissions'], 'catinfo[password]', $cat['password']);
	print_yes_no_row($vbphrase['apply_this_password_to_child_categories'], 'options[childpass]', $options['childpass']);
	print_yes_no_row($vbphrase['can_have_password'], 'options[canhavepassword]', $options['canhavepassword']);

	print_table_header($vbphrase['image_description']);
	print_yes_no_row($vbphrase['allow_html'], 'options[allow_desc_html]', $options['allow_desc_html']);
	print_yes_no_row($vbphrase['allow_bbcode'], 'options[allow_desc_bbcode]', $options['allow_desc_bbcode']);
	print_yes_no_row($vbphrase['allow_img_code'], 'options[allow_desc_bbimgcode]', $options['allow_desc_bbimgcode']);
	print_yes_no_row($vbphrase['allow_smilies'], 'options[allow_desc_smilies]', $options['allow_desc_smilies']);

	print_table_header($vbphrase['custom_fields']);
	print_yes_no_row($vbphrase['allow_html'], 'options[allow_custom_html]', $options['allow_custom_html']);
	print_yes_no_row($vbphrase['allow_bbcode'], 'options[allow_custom_bbcode]', $options['allow_custom_bbcode']);
	print_yes_no_row($vbphrase['allow_img_code'], 'options[allow_custom_bbimgcode]', $options['allow_custom_bbimgcode']);
	print_yes_no_row($vbphrase['allow_smilies'], 'options[allow_custom_smilies]', $options['allow_custom_smilies']);

	print_table_header($vbphrase['posting_options']);
	print_yes_no_row($vbphrase['allow_html'], 'options[allow_post_html]', $options['allow_post_html']);
	print_yes_no_row($vbphrase['allow_bbcode'], 'options[allow_post_bbcode]', $options['allow_post_bbcode']);
	print_yes_no_row($vbphrase['allow_img_code'], 'options[allow_post_bbimgcode]', $options['allow_post_bbimgcode']);
	print_yes_no_row($vbphrase['allow_smilies'], 'options[allow_post_smilies]', $options['allow_post_smilies']);
	print_yes_no_row($vbphrase['allow_icons'], 'options[allow_post_icons]', $options['allow_post_icons']);

	print_table_break();
	print_table_header($vbphrase['allowed_filetypes'], 6);

	?>
	<script type="text/javascript">
	<!--
	function js_check_default(varname)
	{
		document.cpform[ "usedefault[" + varname + "]" ].checked=false
	}
	// -->
	</script>
	<?php

	$types = $DB_site->query("SELECT * FROM " . TABLE_PREFIX . "adv_gallery_filetypes WHERE enabled = 1 ORDER BY extensionid");
	print_cells_row(array($vbphrase['extension'], $vbphrase['max_filesize'], $vbphrase['max_width'], $vbphrase['max_height'], $vbphrase['enabled'], $vbphrase['use_default']), 1);
	while ($type = $DB_site->fetch_array($types))
	{
		$ctarray = unserialize($cat['disext']);

		$typevalue = &$type;
		if (!empty($ctarray["$type[extension]"]))
		{
			$typevalue = &$ctarray["$type[extension]"];
		}

		$cells = array();
		$cells[] = $type['extension'];
		$cells[] = '<input class="bginput" name="extensions[' . $type['extensionid'] . '][filesize]" onfocus="js_check_default(\'' . $type[extensionid] . '\');" size="10" type="text" value="' . $typevalue['filesize'] . '" />';
		$cells[] = '<input class="bginput" name="extensions[' . $type['extensionid'] . '][width]" onfocus="js_check_default(\'' . $type[extensionid] . '\');" size="4" type="text" value="' . $typevalue['width'] . '" />';
		$cells[] = '<input class="bginput" name="extensions[' . $type['extensionid'] . '][height]" onfocus="js_check_default(\'' . $type[extensionid] . '\');" size="4" type="text" value="' . $typevalue['height'] . '" />';

		if (!$typevalue['enabled'])
		{
			$noselected["$type[extensionid]"] = 'checked="checked"';
		}
		else
		{
			$yesselected["$type[extensionid]"] = 'checked="checked"';
		}
		$cells[] = '<label for="enabled_' . $type['extensionid'] . '_yes"><input id="enabled_' . $type['extensionid'] . '_yes" name="extensions[' . $type['extensionid'] . '][enabled]" ' . $yesselected["$type[extensionid]"] . ' onclick="js_check_default(\'' . $type[extensionid] . '\');" type="radio" value="1" />' . $vbphrase['yes'] . '</label> <label for="enabled_' . $type['extensionid'] . '_no"><input id="enabled_' . $type['extensionid'] . '_no" name="extensions[' . $type['extensionid'] . '][enabled]" ' . $noselected["$type[extensionid]"] . ' onclick="js_check_default(\'' . $type[extensionid] . '\');" type="radio" value="0" />' . $vbphrase['no'] . '</label>';

		$cells[] = '<input ' . iif(empty($ctarray["$type[extension]"]), 'checked="checked"') . ' type="checkbox" name="usedefault[' . $type['extensionid'] . ']" value="1" />';

		print_cells_row($cells);
	}

	print_submit_row($vbphrase['save'], $vbphrase['reset'], 6);

}

// ################################# Do Add Cat ###############################
if (in_array($_POST['do'], array('doaddcat', 'doeditcat')))
{

	globalize($_POST, array('catinfo', 'options', 'extensions', 'usedefault', 'useropts'));

	if (!$catinfo['title'])
	{
		print_stop_message('adv_gallery_cant_have_category_without_title');
	}

	if ($catinfo['catusername'])
	{
		$user = $DB_site->query_first("SELECT userid FROM " . TABLE_PREFIX . "user WHERE username = '$catinfo[catusername]'");
		if (!$user['userid'])
		{
			print_stop_message('invalid_user_specified');
		}
	}

	$disext = array();
	$fileext = $DB_site->query("SELECT * FROM " . TABLE_PREFIX . "adv_gallery_filetypes");
	while ($ext = $DB_site->fetch_array($fileext))
	{
		if (!$usedefault["$ext[extensionid]"] AND (!$extensions["$ext[extensionid]"]['enabled'] OR $ext['filesize'] != $extensions["$ext[extensionid]"]['filesize'] OR $extensions["$ext[extensionid]"]['height'] != $ext['height'] OR $extensions["$ext[extensionid]"]['width'] != $ext['width']))
		{
			$disext["$ext[extension]"]['enabled'] = $extensions["$ext[extensionid]"]['enabled'];
			$disext["$ext[extension]"]['filesize'] = $extensions["$ext[extensionid]"]['filesize'];
			$disext["$ext[extension]"]['width'] = $extensions["$ext[extensionid]"]['width'];
			$disext["$ext[extension]"]['height'] = $extensions["$ext[extensionid]"]['height'];
		}
	}

	if (!empty($disext))
	{
		$disext = serialize($disext);
	}
	else
	{
		$disext = '';
	}

	require_once('./includes/functions_misc.php');

	$catoptions = convert_array_to_bits($options, $categoryopts);

	$useroptions = convert_array_to_bits($useropts, $catuseropts);

	if ($_POST['do'] == 'doaddcat')
	{
		if ($catinfo['displayorder'] == -1)
		{
			$DB_site->query("UPDATE " . TABLE_PREFIX . "adv_gallery_categories SET displayorder = displayorder+1 WHERE parent = '$catinfo[parentid]'");
			$catinfo['displayorder'] = 1;
		}

		$DB_site->query("INSERT INTO " . TABLE_PREFIX . "adv_gallery_categories (title, description, hasimages, password, catuserid, active, parent, displayorder, allowusercats, options, useroptions, catimage, disext) VALUES ('" . addslashes($catinfo['title']) . "', '" . addslashes($catinfo['description']) . "', '$catinfo[hasimages]', '" . addslashes($catinfo['password']) . "', '$user[userid]', '$catinfo[active]', '$catinfo[parentid]', '$catinfo[displayorder]', '$catinfo[allowusercats]', '$catoptions', '$useroptions', '$catimage', '$disext')");

		$newcatid = $DB_site->insert_id();

		insert_category_parentlist($catinfo['parentid']);

	}
	else
	{
		if ($catinfo['parentid'] == $catinfo['catid'])
		{
			print_stop_message('adv_gallery_cant_parent_category_to_self');
		}

		$DB_site->query("UPDATE " . TABLE_PREFIX . "adv_gallery_categories SET title = '" . addslashes($catinfo['title']) . "', description = '" . addslashes($catinfo['description']) . "', catuserid = '$user[userid]', parent = '$catinfo[parentid]', password = '" . addslashes($catinfo['password']) . "', active = '$catinfo[active]', hasimages = '$catinfo[hasimages]', displayorder = '$catinfo[displayorder]', allowusercats = $catinfo[allowusercats], options = '$catoptions', catimage = '$catinfo[catimage]', useroptions = '$useroptions', disext = '$disext' WHERE catid = '$catinfo[catid]'");

		if ($catinfo['oldparentid'] != $catinfo['parentid'])
		{
			reconstruct_parents($catinfo['catid']);
		}

		if ($catinfo['password'] != $catinfo['oldpassword'] AND $options['childpass'])
		{
			$getcatids = fetch_category_children($catinfo['catid']);
			$DB_site->query("UPDATE " . TABLE_PREFIX . "adv_gallery_categories SET password = '" . addslashes($catinfo['password']) . "' WHERE catid IN (" . implode(',', $getcatids) . ") AND password = '$catinfo[oldpassword]'");
		}
	}

	update_category_cache();

	print_cp_redirect('vba_gallery_admin.php?' . $session['sessionurl'] . 'do=dirmanager', 0);
}

// ################################ Delete Category ###########################
if ($_REQUEST['do'] == 'deletecat')
{
	globalize($_REQUEST, array('catid' => INT));

	print_form_header('vba_gallery_admin', 'dodeletecat');
	construct_hidden_code('catid', $catid);
	print_table_header($vbphrase['confirm_deletion']);
	print_description_row($vbphrase['are_you_sure_delete_category']);
	print_submit_row($vbphrase['yes'], '', 2, $vbphrase['no']);
}

// ############################# Do Delete Category ##########################
if ($_POST['do'] == 'dodeletecat')
{
	globalize($_POST, array('catid' => INT));

	$getcatids = fetch_category_children($catid);

	$catids = implode(',', $getcatids);

	$deletearray = array();
	$images = $DB_site->query("SELECT imageid, catid, userid, filename, originalname, thumbname FROM " . TABLE_PREFIX . "adv_gallery_images WHERE catid IN($catids)");
	while ($image = $DB_site->fetch_array($images))
	{
		$deletearray["$image[imageid]"]['catid'] = $image['catid'];
		$deletearray["$image[imageid]"]['userid'] = $image['userid'];
		$deletearray["$image[imageid]"]['filename'] = $image['filename'];
		$deletearray["$image[imageid]"]['thumbname'] = $image['thumbname'];
		$deletearray["$image[imageid]"]['originalname'] = $image['originalname'];
	}

	if (is_array($deletearray))
	{
		delete_images('', $deletearray);
	}

	$DB_site->query("DELETE FROM " . TABLE_PREFIX . "adv_gallery_categories WHERE catid IN($catids)");

	update_category_cache();

	print_cp_redirect("vba_gallery_admin.php?$session[sessionurl]do=dirmanager", 0);

}

// ############################### Empty Category #############################
if ($_REQUEST['do'] == 'empty')
{
	globalize($_REQUEST, array('catid' => INT));

	print_form_header('vba_gallery_admin', 'doempty');
	construct_hidden_code('catid', $catid);
	print_table_header($vbphrase['confirm_deletion']);
	print_description_row($vbphrase['are_you_sure_empty_category']);
	print_submit_row($vbphrase['yes'], '', 2, $vbphrase['no']);
}

// ############################# Do Empty Category ############################
if ($_POST['do'] == 'doempty')
{
	globalize($_POST, array('catid' => INT));

	$deletearray = array();
	$images = $DB_site->query("SELECT imageid, userid, filename, thumbname, originalname FROM " . TABLE_PREFIX . "adv_gallery_images WHERE catid = '$catid'");
	while ($image = $DB_site->fetch_array($images))
	{
		$deletearray["$image[imageid]"]['catid'] = $catid;
		$deletearray["$image[imageid]"]['userid'] = $image['userid'];
		$deletearray["$image[imageid]"]['filename'] = $image['filename'];
		$deletearray["$image[imageid]"]['thumbname'] = $image['thumbname'];
		$deletearray["$image[imageid]"]['originalname'] = $image['originalname'];
	}

	if (is_array($deletearray))
	{
		delete_images('', $deletearray);
	}

	$DB_site->query("UPDATE " . TABLE_PREFIX . "adv_gallery_categories SET imagecount = 0, postcount = 0, catimage = '', lastpostusername = '', lastimageid = '', lastimagetitle = '', lastimageuserid = '', lastimageusername = '', lastimagedateline = '', lastpostid = '', lastpostimagetitle = '', lastpostuserid = '', lastpostusername = '', lastpostdateline = '' WHERE catid = '$catid'");

	print_cp_redirect("vba_gallery_admin.php?$session[sessionurl]do=dirmanager", 0);

}

// ############################### List Filetypes #############################
if ($_REQUEST['do'] == 'filetypes')
{
  print_form_header('vba_gallery_admin', 'addfiletype', false, true, 'cpform', '90%', '', true, 'get');
	print_table_header($vbphrase['allowed_filetypes'], 6);
	print_cells_row(array($vbphrase['extension'], $vbphrase['max_filesize'], $vbphrase['max_width'], $vbphrase['max_height'], $vbphrase['enabled'], $vbphrase['controls']), 1);

	$types = $DB_site->query("SELECT * FROM " . TABLE_PREFIX . "adv_gallery_filetypes ORDER BY extensionid");
	while ($type = $DB_site->fetch_array($types))
	{
		$cells = array();
		$cells[] = $type['extension'];
		$cells[] = make_good_size($type['filesize']);
		$cells[] = $type['width'];
		$cells[] = $type['height'];
		$cells[] = iif($type['enabled'], $vbphrase['yes'], $vbphrase['no']);
		$cells[] = construct_link_code($vbphrase['edit'], 'vba_gallery_admin.php?do=editfiletype&amp;extid=' . $type['extensionid']);
		print_cells_row($cells);
	}
	print_submit_row($vbphrase['add_filetype'], '', 6);

}

// ############################# Edit Filetype ################################
if (in_array($_REQUEST['do'], array('addfiletype', 'editfiletype')))
{
	if ($_REQUEST['do'] == 'editfiletype')
	{
		$filetype = $DB_site->query_first("SELECT * FROM " . TABLE_PREFIX . "adv_gallery_filetypes WHERE extensionid = '$_REQUEST[extid]'");
		$table_title = $vbphrase['edit_filetype'] . ': ' . $filetype['extension'];
		$form_action = 'doeditfiletype';
	}
	else
	{
		$table_title = $vbphrase['add_filetype'];
		$form_action = 'doaddfiletype';
		$filetype['enabled'] = true;
	}

	print_form_header('vba_gallery_admin', $form_action);
	print_table_header($table_title);

	if ($_REQUEST['do'] == 'editfiletype')
	{
		construct_hidden_code('filetype[extensionid]', $filetype['extensionid']);
	}

	print_input_row($vbphrase['extension'], 'filetype[extension]', $filetype['extension']);
	print_input_row($vbphrase['maximim_filesize_in_bytes'], 'filetype[filesize]', $filetype['filesize']);
	print_input_row($vbphrase['max_width'], 'filetype[width]', $filetype['width']);
	print_input_row($vbphrase['max_height'], 'filetype[height]', $filetype['height']);
	print_yes_no_row($vbphrase['enabled'], 'filetype[enabled]', $filetype['enabled']);

	print_submit_row();
}

// ########################### Do Add / Edit Filetype #########################
if (in_array($_POST['do'], array('doaddfiletype', 'doeditfiletype')))
{
	globalize($_POST, array('filetype'));

	if ($_POST['do'] == 'doaddfiletype')
	{
		$DB_site->query(fetch_query_sql($filetype, 'adv_gallery_filetypes'));
	}
	else
	{
		$DB_site->query(fetch_query_sql($filetype, 'adv_gallery_filetypes', 'WHERE extensionid = \'' . $filetype['extensionid'] . '\''));
	}

	print_cp_redirect("vba_gallery_admin.php?$session[sessionurl]do=filetypes", 0);
}

// ############################# Mass Edit Images #############################
if ($_REQUEST['do'] == 'massedit')
{
	globalize($_REQUEST, array('showlarge' => INT, 'catid' => INT));

  print_form_header('vba_gallery_admin','domassedit');
	construct_hidden_code('currentcat', $catid);
  print_table_header('<span style="float:' . $stylevar['right'] . '">[<a href="vba_gallery_admin.php?do=massedit&amp;catid=' . $catid . '&amp;showlarge=' . iif($showlarge == 1, '0">' . $vbphrase['show_thumbnails'], '1">' . $vbphrase['show_large_images']) . '</a>]</span>' . $vbphrase['mass_edit_delete'], 2, 0, '', 'left');
	print_table_break();

  $images = $DB_site->query("
  		SELECT adv_gallery_images.*
  		FROM " . TABLE_PREFIX . "adv_gallery_images AS adv_gallery_images
  		WHERE catid = '$catid' ORDER BY imageid
  ");

  while ($image = $DB_site->fetch_array($images))
  {

		print_table_header('<span style="float:' . $stylevar['right'] . '">(' . iif($image['userid'], '<a href="' . $vboptions['bburl'] . '/member.php?u=' . $image['userid'] . '">' . $image['username'] . '</a>', $vbphrase['unregistered']) . ') &nbsp; ' . vbdate($vboptions['dateformat'] . ' ' . $vboptions['timeformat'], $image['dateline']) . '</span>' . $vbphrase['edit_image'] . ': ' . stripslashes($image['title']), 2, 0, '', 'left');
		print_description_row('<img src="' . construct_image_url($image, iif($showlarge, 'filename', 'thumbname')) . '">', 0, 2, '', 'center');

		print_input_row($vbphrase['image_title'], 'title[' . $image['imageid'] . ']', $image['title']);
		print_textarea_row($vbphrase['description'], 'description[' . $image['imageid'] . ']', $image['description']);
		print_category_select('catid[' . $image['imageid'] . ']', $image['catid'], '', $vbphrase['category']);
		print_input_row($vbphrase['keywords'], 'keywords[' . $image['imageid'] . ']', $image['keywords']);
		print_input_row($vbphrase['views'], 'views[' . $image['imageid'] . ']', $image['views']);
		print_yes_no_row($vbphrase['delete'], 'deleteimage[' . $image['imageid'] . ']', 0);
		print_table_break();
	}

	print_submit_row();
}

// ################################ Do Mass Edit ##############################
if ($_POST['do'] == 'domassedit')
{
	globalize($_POST, array('title', 'description', 'keywords', 'views', 'deleteimage', 'catid', 'currentcat' => INT));

	if (is_array($title))
	{
		$updatecats = array();
		foreach ($title AS $imageid => $imagetitle)
		{
			if ($catid["$imageid"] != $currentcat)
			{
				$updatecats[] = $catid["$imageid"];
			}
			$DB_site->query("UPDATE " . TABLE_PREFIX . "adv_gallery_images SET title = '" . addslashes(htmlspecialchars($imagetitle)) . "', description = '" . addslashes($description["$imageid"]) . "', catid = '$catid[$imageid]', keywords = '" . addslashes(htmlspecialchars($keywords["$imageid"])) . "', views = '$views[$imageid]' WHERE imageid = '$imageid'");
		}
	}

	if (!empty($updatecats))
	{
		update_count($currentcat);
		foreach ($updatecats AS $ucatid)
		{
			update_count($ucatid);
		}
	}

	if (is_array($deleteimage))
	{
		$deletearray = array();
		$replyremove = 0;
		$imageremove = 0;
		foreach ($deleteimage AS $imageid => $delete)
		{
			if ($delete)
			{
				$image = $DB_site->query_first("SELECT catid, userid, filename, thumbname, originalname, posts, valid FROM " . TABLE_PREFIX . "adv_gallery_images WHERE imageid = '$imageid'");

				$replyremove += $image['posts'];

				if ($image['valid'])
				{
					$imageremove++;
				}

				$deletearray["$imageid"]['catid'] = $image['catid'];
				$deletearray["$imageid"]['userid'] = $image['userid'];
				$deletearray["$imageid"]['filename'] = $image['filename'];
				$deletearray["$imageid"]['thumbname'] = $image['thumbname'];
				$deletearray["$imageid"]['originalname'] = $image['originalname'];
			}
		}

		if (is_array($deletearray))
		{
			delete_images('', $deletearray);

			$DB_site->query("UPDATE " . TABLE_PREFIX . "adv_gallery_categories SET imagecount = imagecount-$imageremove, postcount = postcount-" . intval($replyremove) . " WHERE catid = '$image[catid]'");
		}
	}

	print_cp_redirect("vba_gallery_admin.php?$session[sessionurl]do=dirmanager", 0);
}


// ################################ Add Moderator #############################
if ($_REQUEST['do'] == 'addmoderator')
{
	globalize($_REQUEST, array('catid' => INT));

	$cat = $DB_site->query_first("SELECT catid, title FROM " . TABLE_PREFIX . "adv_gallery_categories WHERE catid = '$catid'");
	print_form_header('vba_gallery_admin', 'doaddmod');
	print_table_header($vbphrase['add_moderator'] . ' - ' . stripslashes($cat['title']));
	construct_hidden_code('catid', $cat['catid']);
	construct_hidden_code('cattitle', $cat['title']);
	print_description_row($vbphrase['add_moderator_note_permissions']);
	print_input_row($vbphrase['username']. ':', 'username');
	print_submit_row();
}

// ############################### Do Add Moderator ###########################
if ($_POST['do'] == 'doaddmod')
{
	globalize($_POST, array('catid' => INT, 'username' => STR));

	$user = $DB_site->query_first("SELECT userid FROM " . TABLE_PREFIX . "user WHERE username = '" . addslashes($username) . "'");

	if (!$user['userid'])
	{
		print_stop_message('invalid_username_specified');
	}

	$ismod = $DB_site->query_first("SELECT userid FROM " . TABLE_PREFIX . "adv_gallery_moderator WHERE userid = '$user[userid]' AND catid = '$catid'");

	if ($ismod['userid'])
	{
		print_stop_message('user_is_already_mod');
	}

	$DB_site->query("INSERT INTO " . TABLE_PREFIX . "adv_gallery_moderator VALUES ('$user[userid]', '" . addslashes($username) . "', '$catid')");

	update_gallery_mod_cache();

	print_cp_redirect("vba_gallery_admin.php?$session[sessionurl]do=dirmanager", 0);

}

// ############################### Edit Moderator #############################
if ($_REQUEST['do'] == 'editmoderator')
{
	globalize($_REQUEST, array('catid' => INT, 'modid' => INT));

	$moderator = $DB_site->query_first("
			SELECT moderator.userid, moderator.username, moderator.catid, categories.title
			FROM " . TABLE_PREFIX . "adv_gallery_moderator AS moderator
			INNER JOIN " . TABLE_PREFIX . "adv_gallery_categories AS categories USING (catid)
			WHERE userid = '$modid' AND moderator.catid = '$catid'
	");

	if (!$moderator['userid'])
	{
		print_stop_message('invalid_user_specified');
	}

	print_form_header('vba_gallery_admin', 'deletemod');
	construct_hidden_code('userid', $moderator['userid']);
	construct_hidden_code('catid', $moderator['catid']);
	print_table_header(construct_phrase($vbphrase['remove_x_from_moderating_y'], stripslashes($moderator['username']), stripslashes($moderator['title'])) . ' <input type="submit" value="' . $vbphrase['delete'] . '">');
	print_table_footer();
}

// ############################# Do Edit Moderator ############################
if ($_POST['do'] == 'deletemod')
{
	globalize($_POST, array('catid' => INT, 'userid' => INT));

	$DB_site->query("DELETE FROM " . TABLE_PREFIX . "adv_gallery_moderator WHERE userid = '$userid' AND catid = '$catid'");
	update_gallery_mod_cache();
	print_cp_redirect("vba_gallery_admin.php?$session[sessionurl]do=dirmanager", 0);
}


// ############################ Manage Custom Fields ##########################
if ($_REQUEST['do'] == 'customfields')
{
	print_form_header('vba_gallery_admin', 'addcustomfield', false, true, 'cpform', '90%', '', true, 'get');
	print_table_header($vbphrase['add_custom_field']);
	print_select_row($vbphrase['custom_field_type'], 'type', $customfieldtypes);
	print_submit_row($vbphrase['continue'], '');

	print_form_header('vba_gallery_admin', 'ordercustom');
	print_table_header($vbphrase['custom_fields'], 4);
	print_cells_row(array($vbphrase['title'], $vbphrase['type'], $vbphrase['display_order'], $vbphrase['controls']), 1, 'thead', -1);

	$getfields = $DB_site->query("SELECT * FROM " . TABLE_PREFIX . "adv_gallery_customfields ORDER BY displayorder");
	if ($DB_site->num_rows($getfields))
	{
		while ($fields = $DB_site->fetch_array($getfields))
		{
			$cells = array();
			$cells[] = $fields['title'];
			$cells[] = '<span class="smallfont">' . $customfieldtypes["$fields[type]"] . '</span>';
			$cells[] = '<input class="bginput" name="order[' . $fields['fieldid'] . ']" size="3" type="text" value="'  . $fields['displayorder'] . '" />';
			$cells[] = 	construct_link_code($vbphrase['edit'], 'vba_gallery_admin.php?do=editcustomfield&amp;fieldid=' . $fields['fieldid']) . construct_link_code($vbphrase['delete'], 'vba_gallery_admin.php?do=removecustomfield&amp;fieldid=' . $fields['fieldid']);
			print_cells_row($cells, '', '', -1);

		}

		print_submit_row($vbphrase['save_display_order'], $vbphrase['reset'], 4);

	}
	else
	{
		print_description_row($vbphrase['not_added_custom_fields'], '', 6);
	}
	print_table_footer();

}

// ############################ Re-Order Custom Fields ########################
if ($_POST['do'] == 'ordercustom')
{
	globalize($_POST, array('order'));
  foreach ($order AS $key => $disorder)
  {
		$DB_site->query("UPDATE " . TABLE_PREFIX . "adv_gallery_customfields SET displayorder = '$disorder' WHERE fieldid = '$key'");
  }

	print_cp_redirect("vba_gallery_admin.php?$session[sessionurl]&do=customfields", 0);
}

// ############################# Add Custom Field #############################
if (in_array($_REQUEST['do'], array('addcustomfield', 'editcustomfield')))
{

	globalize($_REQUEST, array('type' => STR_NOHTML, 'fieldid' => INT));

	print_form_header('vba_gallery_admin', 'do' . $_REQUEST['do']);

	if ($_REQUEST['do'] == 'editcustomfield')
	{
		$custom = $DB_site->query_first("SELECT * FROM " . TABLE_PREFIX . "adv_gallery_customfields WHERE fieldid = '$fieldid'");
		construct_hidden_code('custom[fieldid]', $custom['fieldid']);
		$type = $custom['type'];
	}

	construct_hidden_code('custom[type]', $type);
	print_table_header(iif($_REQUEST['do'] == 'addcustomfield', $vbphrase['add_custom_field'] . ' - ' . $customfieldtypes["$type"], $vbphrase['edit_custom_field'] . ' - ' . $custom['title']), 4);
	print_input_row($vbphrase['title'], 'custom[title]', $custom['title']);
	print_textarea_row($vbphrase['description'], 'custom[description]', $custom['description']);
	print_input_row($vbphrase['display_order'], 'custom[displayorder]', $custom['displayorder']);
	print_yes_no_row($vbphrase['field_required'], 'custom[required]', $custom['required']);
	print_yes_no_row($vbphrase['field_is_searchable'], 'custom[searchable]', iif($_REQUEST['do'] == 'addcustomfield', 1, $custom['searchable']));

	if (in_array($type, array('text', 'textarea')))
	{
		print_input_row($vbphrase['max_length_of_allowed_user_input'], 'custom[maxlength]', $custom['maxlength']);
	}
	else
	{
		print_textarea_row(construct_phrase($vbphrase['x_enter_the_options_that_the_user_can_choose_from'], $vbphrase['options']), 'custom[options]', $custom['options']);
	}

	print_submit_row();
}

// ############################ Do Add Custom Field ###########################
if (in_array($_POST['do'], array('doaddcustomfield', 'doeditcustomfield')))
{
	globalize($_POST, array('custom'));

	if (!empty($custom))
	{
		$cfields = array();
		foreach ($custom AS $key => $value)
		{
			$cfields["$key"] = htmlspecialchars($value);
		}
	}

	$DB_site->query(fetch_query_sql($cfields, 'adv_gallery_customfields', iif($_POST['do'] == 'doeditcustomfield', 'WHERE fieldid =  ' . $custom['fieldid'])));

	if ($_POST['do'] == 'doaddcustomfield')
	{
		$newfieldid = $DB_site->insert_id();
		$DB_site->query("ALTER TABLE " . TABLE_PREFIX . "adv_gallery_customfields_entries ADD field$newfieldid MEDIUMTEXT NOT NULL");
	}

	print_cp_redirect("vba_gallery_admin.php?$session[sessionurl]&do=customfields", 0);

}

// ############################ Delete Custom Field ###########################
if ($_REQUEST['do'] == 'removecustomfield')
{
	$custom = $DB_site->query_first("SELECT * FROM " . TABLE_PREFIX . "adv_gallery_customfields WHERE fieldid = '$_REQUEST[fieldid]'");

	print_form_header('vba_gallery_admin', 'doremovecustomfield');
	print_table_header($vbphrase['confirm_deletion']);
	construct_hidden_code('fieldid', $custom['fieldid']);
	print_description_row(construct_phrase($vbphrase['are_you_sure_you_want_to_delete_the_x_called_y'], $vbphrase['custom_fields'], $custom['title'], $vbphrase['id'], $custom['fieldid'], ''));
	print_submit_row($vbphrase['yes'], $vbphrase['no']);
}

// ############################ Do Delete Custom Field ########################
if ($_POST['do'] == 'doremovecustomfield')
{
	globalize($_POST, array('fieldid' => INT));
	$DB_site->query("DELETE FROM " . TABLE_PREFIX . "adv_gallery_customfields WHERE fieldid = '$fieldid'");
	$DB_site->query("ALTER TABLE " . TABLE_PREFIX . "adv_gallery_customfields_entries DROP field$fieldid");

	print_cp_redirect("vba_gallery_admin.php?$session[sessionurl]&do=customfields", 0);
}

// ############################### View e-Cards ###############################
if ($_REQUEST['do'] == 'viewecards')
{
	globalize($_REQUEST, array('perpage' => INT, 'pagenumber' => INT));

	if (!$perpage)
	{
		$perpage = 50;
	}

  $countcards = $DB_site->query_first("SELECT COUNT(*) AS count FROM " . TABLE_PREFIX . "adv_gallery_ecards");

	if (!intval($pagenumber))
	{
		$pagenumber = 1;
	}

	$pagecount = ceil($countcards['count'] / $perpage);
	$minlimit = intval(($pagenumber - 1) * $perpage + 1);
	$maxlimit = intval($pagenumber * $perpage);

	if ($maxlimit > $countcards['count'])
	{
		$maxlimit = $countcards['count'];
		if ($minlimit > $countcards['count'])
		{
		  $minlimit = $countcards['count'] - $perpage;
		}
	}
	if ($minlimit <= 0)
	{
	  $minlimit = 1;
	}

	$limit = ($minlimit - 1) . ',' . $perpage;

	print_form_header('vba_gallery_admin', 'viewecards');
	print_table_header($vbphrase['view_ecards']);
	print_cells_row(array($vbphrase['cardid'], $vbphrase['title'], $vbphrase['date'], $vbphrase['to'], $vbphrase['from'], $vbphrase['options']), 1, '', -1);

	$getcards = $DB_site->query("SELECT * FROM " . TABLE_PREFIX . "adv_gallery_ecards ORDER BY cardid DESC LIMIT $limit");
	while ($card = $DB_site->fetch_array($getcards))
	{
		$cells = array();
		$cells[] = $card['cardid'];
		$cells[] = stripslashes($card['title']);
		$cells[] = vbdate($vboptions['dateformat'], $card['dateline']);
		$cells[] = iif($card['userid'], '<a href="' . $vboptions['bburl'] . '/member.php?u=' . $card['userid'] . '" target="_blank">' . $card['tousername'] . '</a>', $card['tousername']);
		$cells[] = iif($card['fromuserid'], '<a href="' . $vboptions['bburl'] . '/member.php?u=' . $card['fromuserid'] . '" target="_blank">' . $card['fromusername'] . '</a>', '<a href="mailto:' . $card['fromemail'] . '">' . $card['fromusername'] . '</a>');
		$cells[] =  construct_link_code($vbphrase['view'], $vba_options['gallery_url'] . '/ecard.php?do=viewcard&amp;cardid=' . $card['cardid'], 1). ' ' . construct_link_code($vbphrase['delete'], 'vba_gallery_admin.php?do=removecard&amp;cardid=' . $card['cardid']);

		print_cells_row($cells, '', '', -1);
	}

	if ($pagecount > 1)
	{
		$pagenav = $vbphrase['pages'] . '(' . $pagecount . ') &nbsp; ';
		$i = 0;
		while ($i++ < $pagecount)
		{
			$pagenav .= '<input class="button" name="pagenumber" type="submit" value="' . iif($i > 9, $i, " $i ") . '"' . iif($i == $pagenumber, ' disabled="disabled"') . ' /> ';
		}
	}
	print_table_header($pagenav, 6);

	print_table_footer();
}

// ############################### Delete e-Card ##############################
if ($_REQUEST['do'] == 'removecard')
{
	print_form_header('vba_gallery_admin', 'doremovecard');
	construct_hidden_code('cardid', $_REQUEST['cardid']);
	print_table_header($vbphrase['confirm_deletion']);
	print_description_row($vbphrase['are_you_sure_delete_this_ecard']);
	print_submit_row($vbphrase['yes'], '', 2, $vbphrase['no']);
}

// ############################# Do Delete e-Card #############################
if ($_POST['do'] == 'doremovecard')
{
	$DB_site->query("DELETE FROM " . TABLE_PREFIX . "adv_gallery_ecards WHERE cardid = '$_POST[cardid]'");
	print_cp_redirect("vba_gallery_admin.php?$session[sessionurl]do=viewecards", 0);
}

// ################################# Maintenance ##############################
if ($_REQUEST['do'] == 'maintenance')
{

	// Update category counters
	print_form_header('vba_gallery_admin', 'updatecounters');
	print_table_header($vbphrase['update_category_counters']);
	print_description_row(
		'<table width="100%" cellpadding="0" cellspacing="3"><tr><td>' . $vbphrase['update_category_counters_desc'] . '</td>
		<td nowrap="nowrap"><input checked="checked" name="imagecount" type="checkbox" value="1" /> ' . $vbphrase['image_counts'] . '<br />
		<input checked="checked" name="postcount" type="checkbox" value="1" /> ' . $vbphrase['post_counts'] . '<br />
		<input checked="checked" name="lastimages" type="checkbox" value="1" /> ' . $vbphrase['last_image_info']  . '
		</td></tr></table>'
	);
	print_submit_row($vbphrase['update_counters'], '');

	// Update Image Post Info
	print_form_header('vba_gallery_admin', 'updatelastpost');
	print_table_header($vbphrase['update_image_information']);
	print_description_row($vbphrase['update_image_info_desc']);
	print_submit_row($vbphrase['update_counters'], '');

	// Rebuild Thumbnails
	print_form_header('vba_gallery_admin', 'rebuildthumbs');
	print_table_header($vbphrase['rebuild_image_sizes']);
	print_description_row($vbphrase['rebuild_image_sizes_desc']);
	print_select_row($vbphrase['type'] . ':', 'thumbs', array(1 => $vbphrase['thumbnails'], 0 => $vbphrase['normal_images']), 1);
	print_category_select('catid', '', $vbphrase['all_categories'], $vbphrase['category']);
	print_select_row($vbphrase['per_page'] . ':', 'perpage', array(10 => 10, 25 => 25, 50 => 50, 75 => 75, 100 => 100));
	print_submit_row($vbphrase['rebuild_image_sizes'], '');

	// Rebuild Image Info
	print_form_header('vba_gallery_admin', 'rebuildimageinfo');
	print_table_header($vbphrase['rebuild_image_info']);
	print_description_row($vbphrase['rebuild_imageinfo_desc']);
	print_category_select('catid', '', $vbphrase['all_categories'], $vbphrase['category']);
	print_select_row($vbphrase['per_page'] . ':', 'perpage', array(10 => 10, 25 => 25, 50 => 50, 75 => 75, 100 => 100));
	print_submit_row($vbphrase['rebuild_image_info'], '');

	// Scan Database
	print_form_header('vba_gallery_admin', 'scandb');
	print_table_header($vbphrase['scan_database']);
	print_description_row($vbphrase['scan_database_for_problems_checks_orphan_broken_images']);
	print_submit_row($vbphrase['scan_database'], '');

	print_form_header('vba_gallery_admin', 'updateusernames');
	print_table_header($vbphrase['update_usernames']);
	print_description_row($vbphrase['update_usernames_desc']);
	print_submit_row($vbphrase['update_usernames'], '');

}

// ################################ Update Counters ###########################
if ($_REQUEST['do'] == 'updatecounters')
{
	globalize($_REQUEST, array('imagecount' => INT, 'postcount' => INT, 'lastimages' => INT));

	if (!$imagecount AND !$postcount AND !$lastimages)
	{
		print_stop_message('adv_gallery_must_choose_update');
	}

	update_count(0, $imagecount, $postcount, $lastimages);
	define('CP_REDIRECT', 'vba_gallery_admin.php?do=maintenance');
	print_stop_message('adv_gallery_updated_counters');
}

// ############################## Rebuild Thumbnails ##########################
if (in_array($_REQUEST['do'], array('rebuildthumbs', 'rebuildimageinfo')))
{
	globalize($_REQUEST, array('perpage' => INT, 'pagenumber' => INT, 'catid' => INT, 'imageid' => INT, 'thumbs' => INT));

	require_once('./includes/functions_gallery_imageedit.php');

	if (!$perpage)
	{
		$perpage = 10;
	}

	if ($imageid)
	{
		$condition = 'imageid = ' . $imageid . ' AND';
	}

	if ($catid)
	{
		$condition = 'catid = ' . $catid . ' AND';
	}

  $countimages = $DB_site->query_first("SELECT COUNT(*) AS count FROM " . TABLE_PREFIX . "adv_gallery_images AS images WHERE $condition valid = 1");

	if (!intval($pagenumber))
	{
		$pagenumber = 1;
	}

	$minlimit = intval(($pagenumber - 1) * $perpage + 1);
	$maxlimit = intval($pagenumber * $perpage);

	if ($maxlimit > $countimages['count'])
	{
		$maxlimit = $countimages['count'];
		if ($minlimit > $countimages['count'])
		{
		  $minlimit = $countimages['count'] - $perpage;
		}
	}
	if ($minlimit <= 0)
	{
	  $minlimit = 1;
	}

	$lastpage = ceil($countimages['count'] / $perpage);

	echo construct_phrase($vbphrase['page_x_of_y'], $pagenumber, $lastpage) . '<br /><br />';

	$limit = ($minlimit - 1) . ',' . $perpage;

	$getimages = $DB_site->query("SELECT imageid, catid, userid, filename AS saveas, thumbname AS currentthumb, width, height, extension, originalname, originalwidth, originalheight FROM " . TABLE_PREFIX . "adv_gallery_images WHERE $condition valid = 1 ORDER BY imageid DESC LIMIT $limit");
	while ($imageinfo = $DB_site->fetch_array($getimages))
	{
		$userid = $imageinfo['userid'];

		$folders = preg_split('//', $imageinfo['userid'], -1, PREG_SPLIT_NO_EMPTY);
		$folderstring = implode('/', $folders);

		$imageinfo['filename'] = $imageinfo['saveas'];
		$imageinfo['saveto'] = $vba_options['gallery_filedirectory'] . '/' . $folderstring;
		$imageinfo['location'] = $imageinfo['saveto'] . '/' . $imageinfo['saveas'];
		$imageinfo['shortname'] = substr($imageinfo['filename'], '', strrpos($imageinfo['filename'], '.'));

		if ($_REQUEST['do'] == 'rebuildthumbs')
		{
			$imagedata = @getimagesize($imageinfo['location']);
			$imageinfo['numericaltype'] = $imagedata[2];
			$imageinfo['type'] = @image_type_to_mime_type($imagedata[2]);

			echo $vbphrase['resizing_image'] . ': ' . $imageinfo['imageid'] . ' (' . $imageinfo['saveas'] . ')<br />';

			if ($thumbs == 1)
			{
				resize_image($vba_options['gallery_thumbsize'], $vba_options['gallery_thumbsize'], 0);
				if ($imageinfo['thumbname'] != $imageinfo['currentthumb'])
				{
					$DB_site->query("UPDATE " . TABLE_PREFIX . "adv_gallery_images SET thumbname = '" . addslashes($imageinfo['thumbname']) . "' WHERE imageid = '$imageinfo[imageid]'");
				}
			}
			else
			{
				$filetypes = fetch_cat_ext_info();

				if ($imageinfo['originalname'])
				{
					$imageinfo['width'] = $imageinfo['originalwidth'];
					$imageinfo['height'] = $imageinfo['originalheight'];
					$savepath = $imageinfo['location'];
					$imageinfo['location'] = $imageinfo['saveto'] . '/' . $imageinfo['originalname'];
				}
				else if	($vba_options['gallery_saveoriginal'] AND ($imageinfo['width'] > $filetypes["$imageinfo[extension]"]['width'] OR $imageinfo['height'] > $filetypes["$imageinfo[extension]"]['height']))
				{
					$imageinfo['location'] = $imageinfo['saveto'] . '/' . $imageinfo['originalname'];
					$imageinfo['originalname'] = $imageinfo['shortname'] . '_original.' . $imageinfo['extension'];
					@copy($imageinfo['location'], $imageinfo['saveto'] . '/' . $imageinfo['originalname']);
					$imageinfo['originalfilesize'] = $imageinfo['filesize'];
					$imageinfo['originalwidth'] = $imageinfo['width'];
					$imageinfo['originalheight'] = $imageinfo['height'];
					// Reduce the quality if necessary
					if (!in_array($vba_options['gallery_origquality'], array(-1, 100)) AND $imageinfo['numericaltype'] != 1)
					{
						modify_image($imageinfo['saveto'] . '/' . $imageinfo['originalname'], $imageinfo['width'], $imageinfo['height'], $vba_options['gallery_origquality']);
						clearstatcache();
						$imageinfo['originalfilesize'] = @filesize($imageinfo['saveto'] . '/' . $imageinfo['originalname']);
					}
				}


				resize_image($filetypes["$imageinfo[extension]"]['width'], $filetypes["$imageinfo[extension]"]['height'], 1, false, $savepath);

			}
		}
		
		if ($_REQUEST['do'] == 'rebuildimageinfo' OR $thumbs == 0)
		{
			$imageinfo['location'] = $imageinfo['saveto'] . '/' . $imageinfo['saveas'];
			$imagedata = @getimagesize($imageinfo['location']);

			clearstatcache();
			$imageinfo['width'] = $imagedata[0];
			$imageinfo['height'] = $imagedata[1];
			$imageinfo['filesize'] = @filesize($imageinfo['location']);
			if ($imageinfo['originalname'])
			{
				$origimagedata = @getimagesize($imageinfo['saveto'] . '/' . $imageinfo['originalname']);
				$imageinfo['originalwidth'] = $origimagedata[0];
				$imageinfo['originalheight'] = $origimagedata[1];
				$imageinfo['originalfilesize'] = @filesize($imageinfo['saveto'] . '/' . $imageinfo['originalname']);
			}

			echo $vbphrase['rebuilding_image_info'] . ': ' . $imageinfo['imageid'] . ' (' . $imageinfo['saveas'] . ')<br />';
			$DB_site->query("UPDATE " . TABLE_PREFIX . "adv_gallery_images SET filesize = '$imageinfo[filesize]', width = '$imageinfo[width]', height = '$imageinfo[height]', originalname = '$imageinfo[originalname]', originalwidth = '$imageinfo[originalwidth]', originalheight = '$imageinfo[originalheight]', originalfilesize = '$imageinfo[originalfilesize]' WHERE imageid = '$imageinfo[imageid]'");
		}
		ob_flush();
		flush();
	}

	$nextpage = $pagenumber+1;

	if ($_REQUEST['cw'])
	{
		print_cp_redirect('vba_gallery_admin.php?' . $session['sessionurl'] . 'do=closebox');
	}
	else
	{
		if ($pagenumber == $lastpage)
		{
			print_cp_redirect('vba_gallery_admin.php?' . $session['sessionurl'] . 'do=maintenance');
		}
		else
		{
			print_cp_redirect('vba_gallery_admin.php?' . $session['sessionurl'] . 'do=' . $_REQUEST['do'] . '&pagenumber=' . $nextpage . '&perpage=' . $perpage . '&catid=' . $catid);
		}
	}
}

// ############################### Scan Database ##############################
if ($_REQUEST['do'] == 'scandb')
{
	print_form_header('vba_gallery_admin', 'fixproblems');
	print_table_header('<span class="smallfont" style="float:' . $stylevar['right'] . '">' . $vbphrase['check_all'] . ' <input name="allbox" onclick="js_check_all(this.form);" type="checkbox" title="' . $vbphrase['check_all'] . '" /></span>' . $vbphrase['problems_found']);

	$filenamecache = array();

	$categories = $DB_site->query("SELECT catid, title FROM " . TABLE_PREFIX . "adv_gallery_categories ORDER BY catid");
	while ($category = $DB_site->fetch_array($categories))
	{
		$problems = array();

		$images = $DB_site->query("SELECT imageid, userid, filename, thumbname, originalname FROM " . TABLE_PREFIX . "adv_gallery_images WHERE catid = '$category[catid]'");
		while ($image = $DB_site->fetch_array($images))
		{
			$folderpath = implode('/', preg_split('//', $image['userid'], -1, PREG_SPLIT_NO_EMPTY));
			if ($image['thumbname'] AND !is_file($vba_options['gallery_filedirectory'] . '/' . $folderpath . '/' . $image['thumbname']))
			{
				$problems["$image[filename]"]['problem'] = 'broken_thumbnail';
				$problems["$image[filename]"]['imageid'] = $image['imageid'];
			}

			if (!is_file($vba_options['gallery_filedirectory'] . '/' . $folderpath . '/' . $image['filename']))
			{
				$problems["$image[filename]"]['problem'] = 'file_not_found';
				$problems["$image[filename]"]['imageid'] = $image['imageid'];
			}

			$filenamecache[] = '/' . $folderpath . '/' . $image['filename'];
			if ($image['thumbname'])
			{
				$filenamecache[] = '/' . $folderpath . '/' . $image['thumbname'];
			}
			if ($image['originalname'])
			{
				$filenamecache[] = '/' . $folderpath . '/' . $image['originalname'];
			}
		}

		$DB_site->free_result($images);
		unset($image);

		if (!empty($problems))
		{
			$counter = 0;
			echo '<tr class="thead"><td colspan="2"><b>' . construct_phrase($vbphrase['x_id_y'], '<a href="' . $vba_options['gallery_url'] . '/browseimages.php?c=' . $category['catid'] . '" target="_blank">' . $category['title'] . '</a>', $category['catid']) . '</b></td></tr>';

			foreach ($problems AS $filename => $problem)
			{
				$totalcounter++;

				echo '<tr class="' . fetch_row_bgclass() . '"><td>' . $vbphrase["$problem[problem]"] . ': ';

				switch ($problem['problem'])
				{
					case 'file_not_found':
						echo '<a href="' . $vba_options['gallery_url'] . '/showimage.php?i=' . $problem['imageid'] . '" target="_blank">' . $filename . '</a></td><td align="' . $stylevar['right'] . '" width="10%" nowrap="nowrap"><label for="fixproblem_' . $problem['imageid'] . '"><span class="smallfont">' . $vbphrase['delete'] . '</span> <input id="fixproblem_' . $problem['imageid'] . '" type="checkbox" name="fixproblem[' . $problem['imageid'] . ']" value="deleteimage"></label></td>';
						break;

					case 'broken_thumbnail':
						echo '<a href="' . $vba_options['gallery_url'] . '/showimage.php?i=' . $problem['imageid'] . '" target="_blank">' . $filename . '</a></td><td align="' . $stylevar['right'] . '" width="10%" nowrap="nowrap"><label for="fixproblem_' . $problem['imageid'] . '"><span class="smallfont">' . $vbphrase['rebuild_thumbnails'] . '</span> <input id="fixproblem_' . $problem['imageid'] . '" type="checkbox" name="fixproblem[' . $problem['imageid'] . ']" value="thumb"></label></td>';
						break;

				}

				echo '</td></tr>';
			}
		}

		flush();
	}

	$ofiles = array();

	fetch_orphaned_files($vba_options['gallery_filedirectory']);

	$orphans = array_diff($ofiles, $filenamecache);

	if (!empty($orphans))
	{
		print_table_break();
		print_table_header($vbphrase['not_in_database']);

		foreach ($orphans AS $ofilename)
		{
			echo '<tr class="' . fetch_row_bgclass() . '"><td><a href="' . $vba_options['gallery_fileurl'] . $ofilename . '" target="_blank">' . $ofilename . '</a></td><td width="10%" nowrap="nowrap"><label for="fixproblem_' . $ofilename . '"><span class="smallfont">' . $vbphrase['delete'] . '</span> <input id="fixproblem_' . $ofilename . '" name="fixproblem[' . $ofilename . ']" type="checkbox" value="deletefile"></label></td></tr>';

		}
	}

	print_table_break();

	print_description_row('<center>' . $vbphrase['total'] . ': ' . intval($totalcounter + sizeof($orphans)) . ' ' . $vbphrase['problems_found'] . '</center>');

	print_table_break();

	print_submit_row($vbphrase['fix_selected_problems'], '');

}

// ################################ Fix Problems ##############################
if ($_POST['do'] == 'fixproblems')
{
	globalize($_POST, array('fixproblem'));

	require_once('./includes/functions_gallery_imageedit.php');

	if (!empty($fixproblem))
	{
		foreach ($fixproblem AS $id => $problem)
		{
			switch ($problem)
			{
				case 'deleteimage':
					delete_images($id);
					$updatecount = true;
					break;

				case 'deletefile':
					unlink($vba_options['gallery_filedirectory'] . $id);
					break;

				case 'thumb':

					$imageinfo = $DB_site->query_first("SELECT imageid, catid, userid, filename AS saveas, thumbname AS currentthumb, width, height, extension FROM " . TABLE_PREFIX . "adv_gallery_images WHERE imageid = '$id' AND valid = 1");

					$userid = $imageinfo['userid'];

					$folders = preg_split('//', $imageinfo['userid'], -1, PREG_SPLIT_NO_EMPTY);
					$folderstring = implode('/', $folders);

					$imageinfo['filename'] = $imageinfo['saveas'];
					$imageinfo['saveto'] = $vba_options['gallery_filedirectory'] . '/' . $folderstring;
					$imageinfo['location'] = $imageinfo['saveto'] . '/' . $imageinfo['saveas'];
					$imageinfo['shortname'] = substr($imageinfo['filename'], '', strrpos($imageinfo['filename'], '.'));

					$imagedata = @getimagesize($imageinfo['location']);
					$imageinfo['numericaltype'] = $imagedata[2];
					$imageinfo['type'] = @image_type_to_mime_type($imagedata[2]);

					resize_image($vba_options['gallery_thumbsize'], $vba_options['gallery_thumbsize'], 0);

					if ($imageinfo['thumbname'] != $imageinfo['currentthumb'])
					{
						$DB_site->query("UPDATE " . TABLE_PREFIX . "adv_gallery_images SET thumbname = '" . addslashes($imageinfo['thumbname']) . "' WHERE imageid = '$imageinfo[imageid]'");
					}

					break;
			}
		}
	}

	if ($updatecount)
	{
		update_count();
	}

	print_cp_redirect("vba_gallery_admin.php?$session[sessionurl]do=maintenance");

}

// ########################## Remove Orphaned File ############################
if ($_REQUEST['do'] == 'removefile')
{
	unlink($vba_options['gallery_filedirectory'] . $_REQUEST['filename']);
	print_cp_redirect("vba_gallery_admin.php?$session[sessionurl]do=closebox");
}

// ############################### Delete Image ###############################
if ($_REQUEST['do'] == 'deleteimage')
{
	delete_images($_REQUEST['imageid']);
	print_cp_redirect("vba_gallery_admin.php?$session[sessionurl]do=closebox");
}

// ############################# Update Usernames #############################
if ($_REQUEST['do'] == 'updateusernames')
{
	$doneuserids = array();
	$users = $DB_site->query("
			SELECT images.userid, images.username AS imageusername, user.username
			FROM " . TABLE_PREFIX . "adv_gallery_images AS images
			LEFT JOIN " . TABLE_PREFIX . "user AS user USING (userid)
	");
	while ($user = $DB_site->fetch_array($users))
	{
		if ($user['imageusername'] != $user['username'] AND !in_array($user['userid'], $doneuserids))
		{
			$DB_site->query("UPDATE " . TABLE_PREFIX . "adv_gallery_images SET username = '" . addslashes($user['username']) . "' WHERE userid = '$user[userid]'");
			$doneuserids[] = $user['userid'];
		}
	}
	print_stop_message('updated_usernames');
}

// ############################ JavaScript Close ############################
if ($_REQUEST['do'] == 'closebox')
{
	?>
	<html>
	<head>
	</head>
	<body>
	<script type="text/javascript">
	  window.close();
	</script>
	</body>
	</html>
	<?
}

// ############################ Update Last Post ##############################
if ($_REQUEST['do'] == 'updatelastpost')
{
	$images = $DB_site->query("SELECT imageid, lastpostdateline, lastpostuserid, lastpostusername, posts FROM " . TABLE_PREFIX . "adv_gallery_images");
	while ($image = $DB_site->fetch_array($images))
	{
		$postcount = $DB_site->query_first("SELECT COUNT(*) AS count FROM " . TABLE_PREFIX . "adv_gallery_posts WHERE imageid = '$image[imageid]'");

		$posts = $DB_site->query_first("SELECT userid, dateline, username FROM " . TABLE_PREFIX . "adv_gallery_posts WHERE imageid = '$image[imageid]' AND visible = 1 ORDER BY dateline DESC");

		$DB_site->query("UPDATE " . TABLE_PREFIX . "adv_gallery_images SET posts = '$postcount[count]', lastpostdateline = '$posts[dateline]', lastpostuserid = '$posts[userid]', lastpostusername = '" . addslashes($posts['username']) . "' WHERE imageid = '$image[imageid]'");

		unset($posts);
	}

	define('CP_REDIRECT', 'vba_gallery_admin.php?do=maintenance');
	print_stop_message('adv_gallery_updated_counters');
}

// ########################## Rebuild Parent Lists ############################
if ($_REQUEST['do'] == 'rebuildparents')
{
	rebuild_parents();
	echo 'Category parents rebuilt.';
}

// ######################### Update Category Cache ###########################
if ($_REQUEST['do'] == 'updatecache')
{
	update_category_cache();
	echo 'Category cache updated.';
}

print_cp_footer();

?>